#include "LPC15xx.h"

/* Define expected signal characteristics */
#define PWM_FREQUENCY           10000                      // PWM frequency in Hz
#define PWM_RESOLUTION_NS       1000                       // Timer resolution in ns
#define PWM_MIN_DUTY_PERCENT    25                         // Minimum allowed duty cycle in %
#define PWM_MAX_DUTY_PERCENT    70                         // Maximum allowed duty cycle in %

/* Derived constants */
#define SCT_PRESCALER           (((SystemCoreClock / 1000u) * PWM_RESOLUTION_NS) / 1000000u - 1u)

#define match_min_width         ((10000000u * PWM_MIN_DUTY_PERCENT) / (PWM_FREQUENCY * PWM_RESOLUTION_NS))
#define match_max_width         ((10000000u * PWM_MAX_DUTY_PERCENT) / (PWM_FREQUENCY * PWM_RESOLUTION_NS))
#define match_no_input          ((10000000u * 300                 ) / (PWM_FREQUENCY * PWM_RESOLUTION_NS))

void SCT0_Init(void)
{
    LPC_SYSCON->SYSAHBCLKCTRL1 |= EN1_SCT0;                // enable the SCT0 clock
    LPC_SCT0->CONFIG           |= (1 << 0) | (1 << 17);    // unified, auto limit

    LPC_SCT0->CTRL_U        |= (SCT_PRESCALER << 5);       // set pre-scaler

    LPC_SCT0->REGMODE_L      = 0x00000018;                 // 3x MATCH, 2x CAPTURE used

    LPC_SCT0->MATCH[0].U     = match_max_width;            // match_max_width
    LPC_SCT0->MATCHREL[0].U  = match_max_width;
    LPC_SCT0->MATCH[1].U     = match_min_width;            // match_min_width
    LPC_SCT0->MATCHREL[1].U  = match_min_width;
    LPC_SCT0->MATCH[2].U     = match_no_input;             // match_no_input
    LPC_SCT0->MATCHREL[2].U  = match_no_input;

    LPC_SCT0->EVENT[0].STATE = 0xFFFFFFFF;                 // event 0 happens in all states
    LPC_SCT0->EVENT[0].CTRL  = (2 << 0)  | (1 << 12);      // related to match_no_input only

    LPC_SCT0->EVENT[1].STATE = 0xFFFFFFFF;                 // event 1 happens in all states
    LPC_SCT0->EVENT[1].CTRL  = (1 << 10) | (2 << 12);      // IN_0 rising edge condition only

    LPC_SCT0->EVENT[2].STATE = (1 << 0);                   // event 2 happens in state 0
    LPC_SCT0->EVENT[2].CTRL  = (1 << 0)  |                 // related to match_min_width
                               (1 << 12) |                 // match condition only
                               (1 << 14) |                 // STATEV is loaded into state
                               (1 << 15);                  // new state is 1

    LPC_SCT0->EVENT[3].STATE = (1 << 1);                   // event 3 happens in state 1
    LPC_SCT0->EVENT[3].CTRL  = (2 << 10) |                 // IN_0 falling edge
                               (2 << 12) |                 // IO condition only
                               (1 << 14) |                 // STATEV is loaded into state
                               (0 << 15);                  // new state is 0

    LPC_SCT0->EVENT[4].STATE = (1 << 1);                   // event 4 happens in state 1
    LPC_SCT0->EVENT[4].CTRL  = (0 << 0)  |                 // related to match_max_width
                               (1 << 12) |                 // match condition only
                               (1 << 14) |                 // STATEV is loaded into state
                               (0 << 15);                  // new state is 0

    LPC_SCT0->EVENT[5].STATE = (1 << 0);                   // event 5 happens in state 0
    LPC_SCT0->EVENT[5].CTRL  = (2 << 10) | (2 << 12);      // IN_0 falling edge condition only

    LPC_SCT0->CAPCTRL[3].U   = (1 << 1);                   // event 1 is causing capture 3
    LPC_SCT0->CAPCTRL[4].U   = (1 << 3) | (1 << 5);        // event 3 and 5 cause capture 4

    LPC_SCT0->OUT[0].SET     = (1 << 1);                   // event 1 set   OUT0 (no timeout)
    LPC_SCT0->OUT[0].CLR     = (1 << 0);                   // event 0 clear OUT0 (timeout)
    LPC_SCT0->OUT[1].SET     = (1 << 3);                   // event 3 set   OUT1 (no width error)
    LPC_SCT0->OUT[1].CLR     = (1 << 0) | (1 << 5);        // event 0 and 5 clear OUT1 (width error)
    LPC_SCT0->OUTPUT        |= 3;                          // default set OUT0 and OUT1

    LPC_SCT0->LIMIT_L        = (1 << 0) | (1 << 1);        // event 0 and 1 limit the timer
    LPC_SCT0->EVEN           = (1 << 0) | (1 << 5);        // event 0 and 5 generate an irq

    NVIC_EnableIRQ(SCT0_IRQn);                             // enable SCT0 interrupt

    LPC_SCT0->CTRL_U           &= ~(1 << 2);               // start timer
}
